// script.js

document.addEventListener('DOMContentLoaded', () => {
    // 1. Smooth Scroll untuk Navigasi
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href');
            if (targetId === '#') return; // Abaikan link hanya '#'
            
            const targetElement = document.querySelector(targetId);
            
            if (targetElement) {
                // Gunakan native smooth scroll
                targetElement.scrollIntoView({
                    behavior: 'smooth'
                });
            }
        });
    });

    // 2. Efek Scroll Sederhana (Contoh: Fade-in elemen saat terlihat)
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                // Tambahkan kelas untuk animasi (misal: 'fade-in')
                entry.target.classList.add('visible');
            }
            // Untuk efek yang hanya terjadi sekali, tambahkan: 
            // else { entry.target.classList.remove('visible'); } 
        });
    }, {
        // threshold 0.2 berarti 20% dari elemen harus terlihat
        threshold: 0.2 
    });

    // Targetkan semua section (kecuali header/footer) untuk animasi
    document.querySelectorAll('.section').forEach(section => {
        section.classList.add('scroll-animate'); // Tambahkan kelas untuk styling CSS
        observer.observe(section);
    });
});

// Tambahkan CSS ini ke style.css untuk efek scroll
/*
.scroll-animate {
    opacity: 0;
    transform: translateY(20px);
    transition: opacity 1s ease-out, transform 1s ease-out;
}

.scroll-animate.visible {
    opacity: 1;
    transform: translateY(0);
}
*/